# nuBuilder Forte 4.5

------------

* ***Home Page:*** https://www.nubuilder.com
* ***Demo:*** https://demo.nubuilder.cloud/
* ***Wiki:*** https://wiki.nubuilder.cloud/
* ***Forum:*** https://forums.nubuilder.cloud/
* ***Requires PHP:*** 5.4.0 (phpMyAdmin that is shipped with nuBuilder will require PHP 7.1+)
* ***Requires MySQL:*** 5.5. (or MariaDB)
* ***Requires a web server:*** (e.g. Apache or Nginx)
* ***License:*** [GPLv3](https://www.gnu.org/licenses/old-licenses/gpl-3.0.html)

------------

## Description

nuBuilder enables you to make any web-based database application that you want or need with the least amount of effort and learning.

It gives its users the ability to do database operations like:

* Search, Create, Insert, Read, Update, Delete


✪ With low-code tools that create ...

- Fast Forms with the Form Builder
- Fast Reports
- Database queries with the SQL Builder
- customised date and number formats with the Format Builder
- calculated fields with the Formula Builder

Further customisation that can be done with JavaScript and PHP.

------------

**✪ Features:**

- low-code
- SQL Builder
- Form Builder
- Report Builder
- User Management
- Access Levels
- 2FA
- WYSIWYG Editor
- File Manager
- File Upload
- Send emails
- Translations
- Import csv files
- Create graphs

------------

**✪ Easy installation:**

- Download and unzip the nuBuilder files
- Upload to your webserver
- Create a database (e.g. nubuilder4 )
- Edit nuconfig.php to set your database and globeadmin credentials
- Open the URL that will look something like: http://yoursitename.com/nubuilder4/index.php
- Done - you can now login as 'globeadmin'

[Detailed installation instructions](https://wiki.nubuilder.cloud/index.php?title=Documentation)


## Documentation

### PDF instructions / Documentation to get started as a nuBuilder developer

* [nuBuilder-Forte-User-Guide 1](https://sourceforge.net/projects/nubuilder/files/nuBuilderForte_UserGuide_OLD.pdf/download)
* [nuBuilder-Forte-User-Guide 2](https://sourceforge.net/projects/nubuilder/files/nuBuilderForte_UserGuide.pdf/download)
* [nuBuilder-Forte-Wiki-Documentation](https://wiki.nubuilder.cloud)

------------

### Alternative to MS-Access
nuBuilder provides an ideal replacement/upgrade from **MS-Access**. It won't get slower and slower as you add more records, unlike **MS-Access**.

### Easy To Learn For End Users
nuBuilder uses an Uncluttered Interface which makes it very easy for new users to find there way around.

### Easy To Learn For Developers
nuBuilder is designed to be as easy as possible to get started with building **Forms** and **Search** Screens. With online videos and documentation, you have all the information you need to become a nuBuilder developer.

### Build Business Applications Fast
nuBuilder makes it affordable to build custom business solutions.

### Web Based
nuBuilder is fully web based which means you can use it anywhere and ***end users do not need to install anything***.

### Open Source
nuBuilder is free to download and install on your own web server with zero licence fees.

### Use your existing PHP and MySQL skills
nuBuilder is built upon industry standard technology stack and does not require you to learn any non-standard languages or templating systems.

### Single File Backup
nuBuilder stores all forms, reports, company data and PHP/JavaScript code in MySQL. You can backup your entire application within a single database file.

### Alternative to Oracle Application Express
nuBuilder is a enterprise level application builder but with no limitations on database size or CPU usage.
