"use strict";
(self["webpackChunkphpmyadmin"] = self["webpackChunkphpmyadmin"] || []).push([[0],[
/* 0 */
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);

/* global Navigation */

/**
 * This object handles ajax requests for pages. It also
 * handles the reloading of the main menu and scripts.
 *
 * @test-module AJAX
 */

window.AJAX = {
  /**
   * @var {boolean} active Whether we are busy
   */
  active: false,

  /**
   * @var {object} source The object whose event initialized the request
   */
  source: null,

  /**
   * @var {object} xhr A reference to the ajax request that is currently running
   */
  xhr: null,

  /**
   * @var {object} lockedTargets, list of locked targets
   */
  lockedTargets: {},
  // eslint-disable-next-line valid-jsdoc

  /**
   * @var {Function} callback Callback to execute after a successful request
   *                          Used by window.CommonActions from common.js
   */
  callback: function () {},

  /**
   * @var {boolean} debug Makes noise in your Firebug console
   */
  debug: false,

  /**
   * @var {object} $msgbox A reference to a jQuery object that links to a message
   *                     box that is generated by Functions.ajaxShowMessage()
   */
  $msgbox: null,

  /**
   * Given the filename of a script, returns a hash to be
   * used to refer to all the events registered for the file
   *
   * @param {string} key key The filename for which to get the event name
   *
   * @return {number}
   */
  hash: function (key) {
    var newKey = key;
    /* https://burtleburtle.net/bob/hash/doobs.html#one */

    newKey += '';
    var len = newKey.length;
    var hash = 0;
    var i = 0;

    for (; i < len; ++i) {
      hash += newKey.charCodeAt(i);
      hash += hash << 10;
      hash ^= hash >> 6;
    }

    hash += hash << 3;
    hash ^= hash >> 11;
    hash += hash << 15;
    return Math.abs(hash);
  },

  /**
   * Registers an onload event for a file
   *
   * @param {string} file   The filename for which to register the event
   * @param {Function} func The function to execute when the page is ready
   *
   * @return {self} For chaining
   */
  registerOnload: function (file, func) {
    var eventName = 'onload_' + window.AJAX.hash(file);
    jquery__WEBPACK_IMPORTED_MODULE_0__(document).on(eventName, func);

    if (this.debug) {
      // eslint-disable-next-line no-console
      console.log( // no need to translate
      'Registered event ' + eventName + ' for file ' + file);
    }

    return this;
  },

  /**
   * Registers a teardown event for a file. This is useful to execute functions
   * that unbind events for page elements that are about to be removed.
   *
   * @param {string} file   The filename for which to register the event
   * @param {Function} func The function to execute when
   *                        the page is about to be torn down
   *
   * @return {self} For chaining
   */
  registerTeardown: function (file, func) {
    var eventName = 'teardown_' + window.AJAX.hash(file);
    jquery__WEBPACK_IMPORTED_MODULE_0__(document).on(eventName, func);

    if (this.debug) {
      // eslint-disable-next-line no-console
      console.log( // no need to translate
      'Registered event ' + eventName + ' for file ' + file);
    }

    return this;
  },

  /**
   * Called when a page has finished loading, once for every
   * file that registered to the onload event of that file.
   *
   * @param {string} file The filename for which to fire the event
   *
   * @return {void}
   */
  fireOnload: function (file) {
    var eventName = 'onload_' + window.AJAX.hash(file);
    jquery__WEBPACK_IMPORTED_MODULE_0__(document).trigger(eventName);

    if (this.debug) {
      // eslint-disable-next-line no-console
      console.log( // no need to translate
      'Fired event ' + eventName + ' for file ' + file);
    }
  },

  /**
   * Called just before a page is torn down, once for every
   * file that registered to the teardown event of that file.
   *
   * @param {string} file The filename for which to fire the event
   *
   * @return {void}
   */
  fireTeardown: function (file) {
    var eventName = 'teardown_' + window.AJAX.hash(file);
    jquery__WEBPACK_IMPORTED_MODULE_0__(document).triggerHandler(eventName);

    if (this.debug) {
      // eslint-disable-next-line no-console
      console.log( // no need to translate
      'Fired event ' + eventName + ' for file ' + file);
    }
  },

  /**
   * function to handle lock page mechanism
   *
   * @param event the event object
   *
   * @return {void}
   */
  lockPageHandler: function (event) {
    // don't consider checkbox event
    if (typeof event.target !== 'undefined') {
      if (event.target.type === 'checkbox') {
        return;
      }
    }

    var newHash = null;
    var oldHash = null;
    var lockId; // CodeMirror lock

    if (event.data.value === 3) {
      newHash = event.data.content;
      oldHash = true;
      lockId = 'cm';
    } else {
      // Don't lock on enter.
      if (0 === event.charCode) {
        return;
      }

      lockId = jquery__WEBPACK_IMPORTED_MODULE_0__(this).data('lock-id');

      if (typeof lockId === 'undefined') {
        return;
      }
      /*
       * @todo Fix Code mirror does not give correct full value (query)
       * in textarea, it returns only the change in content.
       */


      if (event.data.value === 1) {
        newHash = window.AJAX.hash(jquery__WEBPACK_IMPORTED_MODULE_0__(this).val());
      } else {
        newHash = window.AJAX.hash(jquery__WEBPACK_IMPORTED_MODULE_0__(this).is(':checked'));
      }

      oldHash = jquery__WEBPACK_IMPORTED_MODULE_0__(this).data('val-hash');
    } // Set lock if old value !== new value
    // otherwise release lock


    if (oldHash !== newHash) {
      window.AJAX.lockedTargets[lockId] = true;
    } else {
      delete window.AJAX.lockedTargets[lockId];
    } // Show lock icon if locked targets is not empty.
    // otherwise remove lock icon


    if (!jquery__WEBPACK_IMPORTED_MODULE_0__.isEmptyObject(window.AJAX.lockedTargets)) {
      jquery__WEBPACK_IMPORTED_MODULE_0__('#lock_page_icon').html(Functions.getImage('s_lock', window.Messages.strLockToolTip).toString());
    } else {
      jquery__WEBPACK_IMPORTED_MODULE_0__('#lock_page_icon').html('');
    }
  },

  /**
   * resets the lock
   *
   * @return {void}
   */
  resetLock: function () {
    window.AJAX.lockedTargets = {};
    jquery__WEBPACK_IMPORTED_MODULE_0__('#lock_page_icon').html('');
  },
  handleMenu: {
    replace: function (content) {
      jquery__WEBPACK_IMPORTED_MODULE_0__('#floating_menubar').html(content) // Remove duplicate wrapper
      // TODO: don't send it in the response
      .children().first().remove();
      jquery__WEBPACK_IMPORTED_MODULE_0__('#topmenu').menuResizer(Functions.mainMenuResizerCallback);
    }
  },

  /**
   * Event handler for clicks on links and form submissions
   *
   * @param {KeyboardEvent} event Event data
   *
   * @return {boolean | void}
   */
  requestHandler: function (event) {
    // In some cases we don't want to handle the request here and either
    // leave the browser deal with it natively (e.g: file download)
    // or leave an existing ajax event handler present elsewhere deal with it
    var href = jquery__WEBPACK_IMPORTED_MODULE_0__(this).attr('href');

    if (typeof event !== 'undefined' && (event.shiftKey || event.ctrlKey || event.metaKey)) {
      return true;
    } else if (jquery__WEBPACK_IMPORTED_MODULE_0__(this).attr('target')) {
      return true;
    } else if (jquery__WEBPACK_IMPORTED_MODULE_0__(this).hasClass('ajax') || jquery__WEBPACK_IMPORTED_MODULE_0__(this).hasClass('disableAjax')) {
      // reset the lockedTargets object, as specified AJAX operation has finished
      window.AJAX.resetLock();
      return true;
    } else if (href && href.match(/^#/)) {
      return true;
    } else if (href && href.match(/^mailto/)) {
      return true;
    } else if (jquery__WEBPACK_IMPORTED_MODULE_0__(this).hasClass('ui-datepicker-next') || jquery__WEBPACK_IMPORTED_MODULE_0__(this).hasClass('ui-datepicker-prev')) {
      return true;
    }

    if (typeof event !== 'undefined') {
      event.preventDefault();
      event.stopImmediatePropagation();
    } // triggers a confirm dialog if:
    // the user has performed some operations on loaded page
    // the user clicks on some link, (won't trigger for buttons)
    // the click event is not triggered by script


    if (typeof event !== 'undefined' && event.type === 'click' && event.isTrigger !== true && !jquery__WEBPACK_IMPORTED_MODULE_0__.isEmptyObject(window.AJAX.lockedTargets) && confirm(window.Messages.strConfirmNavigation) === false) {
      return false;
    }

    window.AJAX.resetLock();
    var isLink = !!href || false;
    var previousLinkAborted = false;

    if (window.AJAX.active === true) {
      // Cancel the old request if abortable, when the user requests
      // something else. Otherwise silently bail out, as there is already
      // a request well in progress.
      if (window.AJAX.xhr) {
        // In case of a link request, attempt aborting
        window.AJAX.xhr.abort();

        if (window.AJAX.xhr.status === 0 && window.AJAX.xhr.statusText === 'abort') {
          // If aborted
          window.AJAX.$msgbox = Functions.ajaxShowMessage(window.Messages.strAbortedRequest);
          window.AJAX.active = false;
          window.AJAX.xhr = null;
          previousLinkAborted = true;
        } else {
          // If can't abort
          return false;
        }
      } else {
        // In case submitting a form, don't attempt aborting
        return false;
      }
    }

    window.AJAX.source = jquery__WEBPACK_IMPORTED_MODULE_0__(this);
    jquery__WEBPACK_IMPORTED_MODULE_0__('html, body').animate({
      scrollTop: 0
    }, 'fast');
    var url = isLink ? href : jquery__WEBPACK_IMPORTED_MODULE_0__(this).attr('action');
    var argsep = window.CommonParams.get('arg_separator');
    var params = 'ajax_request=true' + argsep + 'ajax_page_request=true';
    var dataPost = window.AJAX.source.getPostData();

    if (!isLink) {
      params += argsep + jquery__WEBPACK_IMPORTED_MODULE_0__(this).serialize();
    } else if (dataPost) {
      params += argsep + dataPost;
      isLink = false;
    }

    if (window.AJAX.debug) {
      // eslint-disable-next-line no-console
      console.log('Loading: ' + url); // no need to translate
    }

    if (isLink) {
      window.AJAX.active = true;
      window.AJAX.$msgbox = Functions.ajaxShowMessage(); // Save reference for the new link request

      window.AJAX.xhr = jquery__WEBPACK_IMPORTED_MODULE_0__.get(url, params, window.AJAX.responseHandler);
      var state = {
        url: href
      };

      if (previousLinkAborted) {
        // hack: there is already an aborted entry on stack
        // so just modify the aborted one
        history.replaceState(state, null, href);
      } else {
        history.pushState(state, null, href);
      }
    } else {
      /**
       * Manually fire the onsubmit event for the form, if any.
       * The event was saved in the jQuery data object by an onload
       * handler defined below. Workaround for bug #3583316
       */
      var onsubmit = jquery__WEBPACK_IMPORTED_MODULE_0__(this).data('onsubmit'); // Submit the request if there is no onsubmit handler
      // or if it returns a value that evaluates to true

      if (typeof onsubmit !== 'function' || onsubmit.apply(this, [event])) {
        window.AJAX.active = true;
        window.AJAX.$msgbox = Functions.ajaxShowMessage();

        if (jquery__WEBPACK_IMPORTED_MODULE_0__(this).attr('id') === 'login_form') {
          jquery__WEBPACK_IMPORTED_MODULE_0__.post(url, params, window.AJAX.loginResponseHandler);
        } else {
          jquery__WEBPACK_IMPORTED_MODULE_0__.post(url, params, window.AJAX.responseHandler);
        }
      }
    }
  },

  /**
   * Response handler to handle login request from login modal after session expiration
   *
   * To refer to self use 'window.AJAX', instead of 'this' as this function
   * is called in the jQuery context.
   *
   * @param {object} data Event data
   *
   * @return {void}
   */
  loginResponseHandler: function (data) {
    if (typeof data === 'undefined' || data === null) {
      return;
    }

    Functions.ajaxRemoveMessage(window.AJAX.$msgbox);
    window.CommonParams.set('token', data.new_token);
    window.AJAX.scriptHandler.load([]);

    if (data.displayMessage) {
      jquery__WEBPACK_IMPORTED_MODULE_0__('#page_content').prepend(data.displayMessage);
      Functions.highlightSql(jquery__WEBPACK_IMPORTED_MODULE_0__('#page_content'));
    }

    jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_errors').remove();
    var msg = '';

    if (data.errSubmitMsg) {
      msg = data.errSubmitMsg;
    }

    if (data.errors) {
      jquery__WEBPACK_IMPORTED_MODULE_0__('<div></div>', {
        id: 'pma_errors',
        class: 'clearfloat d-print-none'
      }).insertAfter('#selflink').append(data.errors); // bind for php error reporting forms (bottom)

      jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_ignore_errors_bottom').on('click', function (e) {
        e.preventDefault();
        Functions.ignorePhpErrors();
      });
      jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_ignore_all_errors_bottom').on('click', function (e) {
        e.preventDefault();
        Functions.ignorePhpErrors(false);
      }); // In case of 'sendErrorReport'='always'
      // submit the hidden error reporting form.

      if (data.sendErrorAlways === '1' && data.stopErrorReportLoop !== '1') {
        jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_report_errors_form').trigger('submit');
        Functions.ajaxShowMessage(window.Messages.phpErrorsBeingSubmitted, false);
        jquery__WEBPACK_IMPORTED_MODULE_0__('html, body').animate({
          scrollTop: jquery__WEBPACK_IMPORTED_MODULE_0__(document).height()
        }, 'slow');
      } else if (data.promptPhpErrors) {
        // otherwise just prompt user if it is set so.
        msg = msg + window.Messages.phpErrorsFound; // scroll to bottom where all the errors are displayed.

        jquery__WEBPACK_IMPORTED_MODULE_0__('html, body').animate({
          scrollTop: jquery__WEBPACK_IMPORTED_MODULE_0__(document).height()
        }, 'slow');
      }
    }

    Functions.ajaxShowMessage(msg, false); // bind for php error reporting forms (popup)

    jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_ignore_errors_popup').on('click', function () {
      Functions.ignorePhpErrors();
    });
    jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_ignore_all_errors_popup').on('click', function () {
      Functions.ignorePhpErrors(false);
    });

    if (typeof data.success !== 'undefined' && data.success) {
      // reload page if user trying to login has changed
      if (window.CommonParams.get('user') !== data.params.user) {
        window.location = 'index.php';
        Functions.ajaxShowMessage(window.Messages.strLoading, false);
        window.AJAX.active = false;
        window.AJAX.xhr = null;
        return;
      } // remove the login modal if the login is successful otherwise show error.


      if (typeof data.logged_in !== 'undefined' && data.logged_in === 1) {
        if (jquery__WEBPACK_IMPORTED_MODULE_0__('#modalOverlay').length) {
          jquery__WEBPACK_IMPORTED_MODULE_0__('#modalOverlay').remove();
        }

        jquery__WEBPACK_IMPORTED_MODULE_0__('fieldset.disabled_for_expiration').removeAttr('disabled').removeClass('disabled_for_expiration');
        window.AJAX.fireTeardown('functions.js');
        window.AJAX.fireOnload('functions.js');
      }

      if (typeof data.new_token !== 'undefined') {
        jquery__WEBPACK_IMPORTED_MODULE_0__('input[name=token]').val(data.new_token);
      }
    } else if (typeof data.logged_in !== 'undefined' && data.logged_in === 0) {
      jquery__WEBPACK_IMPORTED_MODULE_0__('#modalOverlay').replaceWith(data.error);
    } else {
      Functions.ajaxShowMessage(data.error, false);
      window.AJAX.active = false;
      window.AJAX.xhr = null;
      Functions.handleRedirectAndReload(data);

      if (data.fieldWithError) {
        jquery__WEBPACK_IMPORTED_MODULE_0__(':input.error').removeClass('error');
        jquery__WEBPACK_IMPORTED_MODULE_0__('#' + data.fieldWithError).addClass('error');
      }
    }
  },

  /**
   * Called after the request that was initiated by this.requestHandler()
   * has completed successfully or with a caught error. For completely
   * failed requests or requests with uncaught errors, see the .ajaxError
   * handler at the bottom of this file.
   *
   * To refer to self use 'window.AJAX', instead of 'this' as this function
   * is called in the jQuery context.
   *
   * @param {object} data Event data
   *
   * @return {void}
   */
  responseHandler: function (data) {
    if (typeof data === 'undefined' || data === null) {
      return;
    } // Can be a string when an error occurred and only HTML was returned.


    if (typeof data === 'string') {
      Functions.ajaxRemoveMessage(window.AJAX.$msgbox);
      Functions.ajaxShowMessage(jquery__WEBPACK_IMPORTED_MODULE_0__(data).text(), false, 'error');
      window.AJAX.active = false;
      window.AJAX.xhr = null;
      return;
    }

    if (typeof data.success !== 'undefined' && data.success) {
      jquery__WEBPACK_IMPORTED_MODULE_0__('html, body').animate({
        scrollTop: 0
      }, 'fast');
      Functions.ajaxRemoveMessage(window.AJAX.$msgbox);

      if (data.redirect) {
        Functions.ajaxShowMessage(data.redirect, false);
        window.AJAX.active = false;
        window.AJAX.xhr = null;
        return;
      }

      window.AJAX.scriptHandler.reset(function () {
        if (data.reloadNavigation) {
          Navigation.reload();
        }

        if (data.title) {
          jquery__WEBPACK_IMPORTED_MODULE_0__('title').replaceWith(data.title);
        }

        if (data.menu) {
          var state = {
            url: data.selflink,
            menu: data.menu
          };
          history.replaceState(state, null);
          window.AJAX.handleMenu.replace(data.menu);
        }

        if (data.disableNaviSettings) {
          Navigation.disableSettings();
        } else {
          Navigation.ensureSettings(data.selflink);
        } // Remove all containers that may have
        // been added outside of #page_content


        jquery__WEBPACK_IMPORTED_MODULE_0__('body').children().not('#pma_navigation').not('#floating_menubar').not('#page_nav_icons').not('#page_content').not('#selflink').not('#pma_header').not('#pma_footer').not('#pma_demo').not('#pma_console_container').not('#prefs_autoload').remove(); // Replace #page_content with new content

        if (data.message && data.message.length > 0) {
          jquery__WEBPACK_IMPORTED_MODULE_0__('#page_content').replaceWith('<div id=\'page_content\'>' + data.message + '</div>');
          Functions.highlightSql(jquery__WEBPACK_IMPORTED_MODULE_0__('#page_content'));
          Functions.checkNumberOfFields();
        }

        if (data.selflink) {
          var source = data.selflink.split('?')[0]; // Check for faulty links

          var $selflinkReplace = {
            'index.php?route=/import': 'index.php?route=/table/sql',
            'index.php?route=/table/chart': 'index.php?route=/sql',
            'index.php?route=/table/gis-visualization': 'index.php?route=/sql'
          };

          if ($selflinkReplace[source]) {
            var replacement = $selflinkReplace[source];
            data.selflink = data.selflink.replace(source, replacement);
          }

          jquery__WEBPACK_IMPORTED_MODULE_0__('#selflink').find('> a').attr('href', data.selflink);
        }

        if (data.params) {
          window.CommonParams.setAll(data.params);
        }

        if (data.scripts) {
          window.AJAX.scriptHandler.load(data.scripts);
        }

        if (data.displayMessage) {
          jquery__WEBPACK_IMPORTED_MODULE_0__('#page_content').prepend(data.displayMessage);
          Functions.highlightSql(jquery__WEBPACK_IMPORTED_MODULE_0__('#page_content'));
        }

        jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_errors').remove();
        var msg = '';

        if (data.errSubmitMsg) {
          msg = data.errSubmitMsg;
        }

        if (data.errors) {
          jquery__WEBPACK_IMPORTED_MODULE_0__('<div></div>', {
            id: 'pma_errors',
            class: 'clearfloat d-print-none'
          }).insertAfter('#selflink').append(data.errors); // bind for php error reporting forms (bottom)

          jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_ignore_errors_bottom').on('click', function (e) {
            e.preventDefault();
            Functions.ignorePhpErrors();
          });
          jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_ignore_all_errors_bottom').on('click', function (e) {
            e.preventDefault();
            Functions.ignorePhpErrors(false);
          }); // In case of 'sendErrorReport'='always'
          // submit the hidden error reporting form.

          if (data.sendErrorAlways === '1' && data.stopErrorReportLoop !== '1') {
            jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_report_errors_form').trigger('submit');
            Functions.ajaxShowMessage(window.Messages.phpErrorsBeingSubmitted, false);
            jquery__WEBPACK_IMPORTED_MODULE_0__('html, body').animate({
              scrollTop: jquery__WEBPACK_IMPORTED_MODULE_0__(document).height()
            }, 'slow');
          } else if (data.promptPhpErrors) {
            // otherwise just prompt user if it is set so.
            msg = msg + window.Messages.phpErrorsFound; // scroll to bottom where all the errors are displayed.

            jquery__WEBPACK_IMPORTED_MODULE_0__('html, body').animate({
              scrollTop: jquery__WEBPACK_IMPORTED_MODULE_0__(document).height()
            }, 'slow');
          }
        }

        Functions.ajaxShowMessage(msg, false); // bind for php error reporting forms (popup)

        jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_ignore_errors_popup').on('click', function () {
          Functions.ignorePhpErrors();
        });
        jquery__WEBPACK_IMPORTED_MODULE_0__('#pma_ignore_all_errors_popup').on('click', function () {
          Functions.ignorePhpErrors(false);
        });

        if (typeof window.AJAX.callback === 'function') {
          window.AJAX.callback.call();
        }

        window.AJAX.callback = function () {};
      });
    } else {
      Functions.ajaxShowMessage(data.error, false);
      Functions.ajaxRemoveMessage(window.AJAX.$msgbox);
      var $ajaxError = jquery__WEBPACK_IMPORTED_MODULE_0__('<div></div>');
      $ajaxError.attr({
        'id': 'ajaxError'
      });
      jquery__WEBPACK_IMPORTED_MODULE_0__('#page_content').append($ajaxError);
      $ajaxError.html(data.error);
      jquery__WEBPACK_IMPORTED_MODULE_0__('html, body').animate({
        scrollTop: jquery__WEBPACK_IMPORTED_MODULE_0__(document).height()
      }, 200);
      window.AJAX.active = false;
      window.AJAX.xhr = null;
      Functions.handleRedirectAndReload(data);

      if (data.fieldWithError) {
        jquery__WEBPACK_IMPORTED_MODULE_0__(':input.error').removeClass('error');
        jquery__WEBPACK_IMPORTED_MODULE_0__('#' + data.fieldWithError).addClass('error');
      }
    }
  },

  /**
   * This object is in charge of downloading scripts,
   * keeping track of what's downloaded and firing
   * the onload event for them when the page is ready.
   */
  scriptHandler: {
    /**
     * @var {string[]} scripts The list of files already downloaded
     */
    scripts: [],

    /**
     * @var {string} scriptsVersion version of phpMyAdmin from which the
     *                              scripts have been loaded
     */
    scriptsVersion: null,

    /**
     * @var {string[]} scriptsToBeLoaded The list of files that
     *                                   need to be downloaded
     */
    scriptsToBeLoaded: [],

    /**
     * @var {string[]} scriptsToBeFired The list of files for which
     *                                  to fire the onload and unload events
     */
    scriptsToBeFired: [],
    scriptsCompleted: false,

    /**
     * Records that a file has been downloaded
     *
     * @param {string} file The filename
     * @param {string} fire Whether this file will be registering
     *                      onload/teardown events
     *
     * @return {self} For chaining
     */
    add: function (file, fire) {
      this.scripts.push(file);

      if (fire) {
        // Record whether to fire any events for the file
        // This is necessary to correctly tear down the initial page
        this.scriptsToBeFired.push(file);
      }

      return this;
    },

    /**
     * Download a list of js files in one request
     *
     * @param {string[]} files An array of filenames and flags
     * @param {Function} callback
     *
     * @return {void}
     */
    load: function (files, callback) {
      var self = this;
      var i; // Clear loaded scripts if they are from another version of phpMyAdmin.
      // Depends on common params being set before loading scripts in responseHandler

      if (self.scriptsVersion === null) {
        self.scriptsVersion = window.CommonParams.get('version');
      } else if (self.scriptsVersion !== window.CommonParams.get('version')) {
        self.scripts = [];
        self.scriptsVersion = window.CommonParams.get('version');
      }

      self.scriptsCompleted = false;
      self.scriptsToBeFired = []; // We need to first complete list of files to load
      // as next loop will directly fire requests to load them
      // and that triggers removal of them from
      // self.scriptsToBeLoaded

      for (i in files) {
        self.scriptsToBeLoaded.push(files[i].name);

        if (files[i].fire) {
          self.scriptsToBeFired.push(files[i].name);
        }
      }

      for (i in files) {
        var script = files[i].name; // Only for scripts that we don't already have

        if (jquery__WEBPACK_IMPORTED_MODULE_0__.inArray(script, self.scripts) === -1) {
          this.add(script);
          this.appendScript(script, callback);
        } else {
          self.done(script, callback);
        }
      } // Trigger callback if there is nothing else to load


      self.done(null, callback);
    },

    /**
     * Called whenever all files are loaded
     *
     * @param {string} script
     * @param {Function?} callback
     *
     * @return {void}
     */
    done: function (script, callback) {
      if (jquery__WEBPACK_IMPORTED_MODULE_0__.inArray(script, this.scriptsToBeFired)) {
        window.AJAX.fireOnload(script);
      }

      if (jquery__WEBPACK_IMPORTED_MODULE_0__.inArray(script, this.scriptsToBeLoaded)) {
        this.scriptsToBeLoaded.splice(jquery__WEBPACK_IMPORTED_MODULE_0__.inArray(script, this.scriptsToBeLoaded), 1);
      }

      if (script === null) {
        this.scriptsCompleted = true;
      }
      /* We need to wait for last signal (with null) or last script load */


      window.AJAX.active = this.scriptsToBeLoaded.length > 0 || !this.scriptsCompleted;
      /* Run callback on last script */

      if (!window.AJAX.active && typeof callback === 'function') {
        callback();
      }
    },

    /**
     * Appends a script element to the head to load the scripts
     *
     * @param {string} name
     * @param {Function} callback
     *
     * @return {void}
     */
    appendScript: function (name, callback) {
      var head = document.head || document.getElementsByTagName('head')[0];
      var script = document.createElement('script');
      var self = this;
      script.type = 'text/javascript';
      var file = name.indexOf('vendor/') !== -1 ? name : 'dist/' + name;
      script.src = 'js/' + file + '?' + 'v=' + encodeURIComponent(window.CommonParams.get('version'));
      script.async = false;

      script.onload = function () {
        self.done(name, callback);
      };

      head.appendChild(script);
    },

    /**
     * Fires all the teardown event handlers for the current page
     * and rebinds all forms and links to the request handler
     *
     * @param {Function} callback The callback to call after resetting
     *
     * @return {void}
     */
    reset: function (callback) {
      for (var i in this.scriptsToBeFired) {
        window.AJAX.fireTeardown(this.scriptsToBeFired[i]);
      }

      this.scriptsToBeFired = [];
      /**
       * Re-attach a generic event handler to clicks
       * on pages and submissions of forms
       */

      jquery__WEBPACK_IMPORTED_MODULE_0__(document).off('click', 'a').on('click', 'a', window.AJAX.requestHandler);
      jquery__WEBPACK_IMPORTED_MODULE_0__(document).off('submit', 'form').on('submit', 'form', window.AJAX.requestHandler);
      callback();
    }
  },

  /**
   * Here we register a function that will remove the onsubmit event from all
   * forms that will be handled by the generic page loader. We then save this
   * event handler in the "jQuery data", so that we can fire it up later in
   * window.AJAX.requestHandler().
   *
   * See bug #3583316
   */
  removeSubmitEvents: function () {
    // Registering the onload event for functions.js
    // ensures that it will be fired for all pages
    jquery__WEBPACK_IMPORTED_MODULE_0__('form').not('.ajax').not('.disableAjax').each(function () {
      if (jquery__WEBPACK_IMPORTED_MODULE_0__(this).attr('onsubmit')) {
        jquery__WEBPACK_IMPORTED_MODULE_0__(this).data('onsubmit', this.onsubmit).attr('onsubmit', '');
      }
    });
    var $pageContent = jquery__WEBPACK_IMPORTED_MODULE_0__('#page_content');
    /**
     * Workaround for passing submit button name,value on ajax form submit
     * by appending hidden element with submit button name and value.
     */

    $pageContent.on('click', 'form input[type=submit]', function () {
      var buttonName = jquery__WEBPACK_IMPORTED_MODULE_0__(this).attr('name');

      if (typeof buttonName === 'undefined') {
        return;
      }

      jquery__WEBPACK_IMPORTED_MODULE_0__(this).closest('form').append(jquery__WEBPACK_IMPORTED_MODULE_0__('<input>', {
        'type': 'hidden',
        'name': buttonName,
        'value': jquery__WEBPACK_IMPORTED_MODULE_0__(this).val()
      }));
    });
    /**
     * Attach event listener to events when user modify visible
     * Input,Textarea and select fields to make changes in forms
     */

    $pageContent.on('keyup change', 'form.lock-page textarea, ' + 'form.lock-page input[type="text"], ' + 'form.lock-page input[type="number"], ' + 'form.lock-page select', {
      value: 1
    }, window.AJAX.lockPageHandler);
    $pageContent.on('change', 'form.lock-page input[type="checkbox"], ' + 'form.lock-page input[type="radio"]', {
      value: 2
    }, window.AJAX.lockPageHandler);
    /**
     * Reset lock when lock-page form reset event is fired
     * Note: reset does not bubble in all browser so attach to
     * form directly.
     */

    jquery__WEBPACK_IMPORTED_MODULE_0__('form.lock-page').on('reset', function () {
      window.AJAX.resetLock();
    });
  },

  /**
   * Page load event handler
   * @return {function}
   */
  loadEventHandler: function () {
    return function () {
      var menuContent = jquery__WEBPACK_IMPORTED_MODULE_0__('<div></div>').append(jquery__WEBPACK_IMPORTED_MODULE_0__('#server-breadcrumb').clone()).append(jquery__WEBPACK_IMPORTED_MODULE_0__('#topmenucontainer').clone()).html(); // set initial state reload

      var initState = 'state' in window.history && window.history.state !== null;
      var initURL = jquery__WEBPACK_IMPORTED_MODULE_0__('#selflink').find('> a').attr('href') || location.href;
      var state = {
        url: initURL,
        menu: menuContent
      };
      history.replaceState(state, null);
      jquery__WEBPACK_IMPORTED_MODULE_0__(window).on('popstate', function (event) {
        var initPop = !initState && location.href === initURL;
        initState = true; // check if popstate fired on first page itself

        if (initPop) {
          return;
        }

        var state = event.originalEvent.state;

        if (state && state.menu) {
          window.AJAX.$msgbox = Functions.ajaxShowMessage();
          var params = 'ajax_request=true' + window.CommonParams.get('arg_separator') + 'ajax_page_request=true';
          var url = state.url || location.href;
          jquery__WEBPACK_IMPORTED_MODULE_0__.get(url, params, window.AJAX.responseHandler); // TODO: Check if sometimes menu is not retrieved from server,
          // Not sure but it seems menu was missing only for printview which
          // been removed lately, so if it's right some dead menu checks/fallbacks
          // may need to be removed from this file and Header.php
          // window.AJAX.handleMenu.replace(event.originalEvent.state.menu);
        }
      });
    };
  },

  /**
   * Gracefully handle fatal server errors (e.g: 500 - Internal server error)
   * @return {function}
   */
  getFatalErrorHandler: function () {
    return function (event, request) {
      if (window.AJAX.debug) {
        // eslint-disable-next-line no-console
        console.log('AJAX error: status=' + request.status + ', text=' + request.statusText);
      } // Don't handle aborted requests


      if (request.status !== 0 || request.statusText !== 'abort') {
        var details = '';
        var state = request.state();

        if ('responseJSON' in request && 'isErrorResponse' in request.responseJSON && request.responseJSON.isErrorResponse) {
          Functions.ajaxShowMessage('<div class="alert alert-danger" role="alert">' + Functions.escapeHtml(request.responseJSON.error) + '</div>', false);
          window.AJAX.active = false;
          window.AJAX.xhr = null;
          return;
        }

        if (request.status !== 0) {
          details += '<div>' + Functions.escapeHtml(Functions.sprintf(window.Messages.strErrorCode, request.status)) + '</div>';
        }

        details += '<div>' + Functions.escapeHtml(Functions.sprintf(window.Messages.strErrorText, request.statusText + ' (' + state + ')')) + '</div>';

        if (state === 'rejected' || state === 'timeout') {
          details += '<div>' + Functions.escapeHtml(window.Messages.strErrorConnection) + '</div>';
        }

        Functions.ajaxShowMessage('<div class="alert alert-danger" role="alert">' + window.Messages.strErrorProcessingRequest + details + '</div>', false);
        window.AJAX.active = false;
        window.AJAX.xhr = null;
      }
    };
  }
};

/***/ }),
/* 1 */
/***/ (function(module) {

module.exports = jQuery;

/***/ })
],
/******/ function(__webpack_require__) { // webpackRuntimeModules
/******/ var __webpack_exec__ = function(moduleId) { return __webpack_require__(__webpack_require__.s = moduleId); }
/******/ var __webpack_exports__ = (__webpack_exec__(0));
/******/ }
]);
//# sourceMappingURL=ajax.js.map